/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;

public class LegacyTallRiceCropBlock
extends BushBlock
implements IWaterLoggable,
IGrowable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)5, (int)7);

    @Deprecated
    public LegacyTallRiceCropBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(5)));
    }

    protected static void breakDoublePlant(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            if (blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                world.func_180501_a(blockpos, Blocks.field_150355_j.func_176223_P(), 35);
            } else {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            }
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER && worldIn.func_226659_b_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = 10.0f)) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && (Integer)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((Property)AGE) < this.getMaxAge()) {
                worldIn.func_180501_a(pos.func_177977_b(), (BlockState)worldIn.func_180495_p(pos.func_177977_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow((World)worldIn, pos, state);
    }

    protected IItemProvider getSeedsItem() {
        return (IItemProvider)ModItems.RICE.get();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)));
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            worldIn.func_175656_a(pos.func_177977_b(), (BlockState)worldIn.func_180495_p(pos.func_177977_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)));
        } else {
            worldIn.func_175656_a(pos.func_177984_a(), (BlockState)worldIn.func_180495_p(pos.func_177984_a()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        DoubleBlockHalf half = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (!blockstate.func_196958_f()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return blockpos.func_177956_o() < 255 && ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) ? super.func_196258_a(context) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags, int age) {
        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (player.func_184812_l_()) {
                LegacyTallRiceCropBlock.breakDoublePlant(worldIn, pos, state, player);
            } else {
                LegacyTallRiceCropBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, AGE, HALF});
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_224755_d(worldIn, pos, Direction.UP) && (state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == ModBlocks.RICH_SOIL.get());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) != DoubleBlockHalf.UPPER) {
            FluidState ifluidstate = worldIn.func_204610_c(pos);
            return this.func_200014_a_(worldIn.func_180495_p(pos.func_177977_b()), (IBlockReader)worldIn, pos) && ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, worldIn, pos);
        }
        return blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return ((Block)ModBlocks.TALL_RICE_CROP.get()).func_176223_P();
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return true;
    }

    public FluidState func_204507_t(BlockState state) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }
}

